<?php
/**
 * Plugin Name:           AutomatorWP - QR Code
 * Plugin URI:            https://automatorwp.com/add-ons/qr-code/
 * Description:           Connect AutomatorWP with QR Code.
 * Version:               1.0.4
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-qr-code
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:         	  GPLv3 (http://www.gnu.org/licenses/gpl-3.0.html)
 *
 * @package               AutomatorWP\QR_Code
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_QR_Code {

    /**
     * @var         AutomatorWP_QR_Code $instance The one true AutomatorWP_QR_Code
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_QR_Code self::$instance The one true AutomatorWP_QR_Code
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_QR_Code();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_QR_CODE_VER', '1.0.4' );

        // Plugin file
        define( 'AUTOMATORWP_QR_CODE_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_QR_CODE_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_QR_CODE_URL', plugin_dir_url( __FILE__ ) );

        // QR Code constants
        $upload_dir = wp_upload_dir();
        $plugin_dir = apply_filters( 'automatorwp_qr_code_upload_dir', 'automatorwp-pro' );

        define( 'AUTOMATORWP_QR_CODE_UPLOAD_DIR', $upload_dir['basedir'] . '/' . $plugin_dir . '/' );
        define( 'AUTOMATORWP_QR_CODE_UPLOAD_URL', $upload_dir['baseurl'] . '/' . $plugin_dir . '/' );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            //Actions
            require_once AUTOMATORWP_QR_CODE_DIR . 'includes/actions/generate-qr-code.php';

            // Includes
            require_once AUTOMATORWP_QR_CODE_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_QR_CODE_DIR . 'includes/tags.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'qr_code', array(
            'label' => 'QR Code',
            'icon'  => AUTOMATORWP_QR_CODE_URL . 'assets/qr-code.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_QR_Code instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_QR_Code The one true AutomatorWP_QR_Code
 */
function AutomatorWP_QR_Code() {
    return AutomatorWP_QR_Code::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_QR_Code' );
